<?php
/**
 * ColorMag dynamic CSS generation file for theme options.
 *
 * Class ColorMag_Dynamic_CSS
 *
 * @package ColorMag
 *
 * @since   ColorMag 3.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ColorMag dynamic CSS generation file for theme options.
 *
 * Class ColorMag_Dynamic_CSS
 */
class ColorMag_Dynamic_CSS {

	/**
	 * Return dynamic CSS output.
	 *
	 * @param string $dynamic_css          Dynamic CSS.
	 * @param string $dynamic_css_filtered Dynamic CSS Filters.
	 *
	 * @return string Generated CSS.
	 */
	public static function render_output( $dynamic_css, $dynamic_css_filtered = '' ) {

		/**
		 * Variable declarations.
		 */

		// Top bar color options
		$top_bar_background_color             = get_theme_mod( 'colormag_top_bar_background_color', '#fff' );
		$top_bar_text_color                   = get_theme_mod( 'colormag_top_bar_text_color', '#555' );
		$top_bar_link_color                   = get_theme_mod( 'colormag_top_bar_link_color', '#207daf' );
		$top_bar_link_hover_color             = get_theme_mod( 'colormag_top_bar_link_hover_color', '' );
		$top_bar_label_color                  = get_theme_mod( 'colormag_top_bar_label_color', '#555' );
		$breaking_news_label_background_color = get_theme_mod( 'colormag_news_ticker_label_background' );
		$breaking_news_background_color       = get_theme_mod( 'colormag_news_ticker_background' );

		$breaking_news_label_typography_default = array(
			'font-family' => 'default',
			'font-weight' => 600,
			'font-size'   => array(
				'desktop' => array(
					'size' => '14',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);

		$breaking_news_content_typography_default = array(
			'font-family' => 'default',
			'font-weight' => 600,
			'font-size'   => array(
				'desktop' => array(
					'size' => '14',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);

		// Top bar typography option.
		$breaking_news_label_typography   = get_theme_mod( 'colormag_news_ticker_label_typography', $breaking_news_label_typography_default );
		$breaking_news_content_typography = get_theme_mod( 'colormag_news_ticker_content_typography', $breaking_news_content_typography_default );

		// Header options.

		$primary_menu_text_color                  = get_theme_mod( 'colormag_primary_menu_text_color', '' );
		$primary_menu_selected_hovered_text_color = get_theme_mod( 'colormag_primary_menu_selected_hovered_text_color', '' );
		$primary_menu_top_border_color            = get_theme_mod( 'colormag_primary_menu_top_border_color', '#207daf' );

		$header_background_default       = array(
			'background-color'      => '#ffffff',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$site_title_typography_default   = array(
			'font-family' => 'default',
			'font-size'   => array(
				'desktop' => array(
					'size' => '40',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$site_tagline_typography_default = array(
			'font-family' => 'default',
			'font-size'   => array(
				'desktop' => array(
					'size' => '16',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);

		$primary_menu_background_default     = array(
			'background-color'      => '#27272A',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$primary_sub_menu_background_default = array(
			'background-color'      => '#232323',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$primary_menu_typography_default     = array(
			'font-family' => 'default',
			'font-weight' => 600,
			'font-size'   => array(
				'desktop' => array(
					'size' => '14',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$primary_sub_menu_typography_default = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '14',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$post_title_typography_default       = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'font-size'      => array(
				'desktop' => array(
					'size' => '24',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.3',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		);

		$single_post_title_typography_default       = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'font-size'      => array(
				'desktop' => array(
					'size' => '',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.3',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		);

		$header_background           = get_theme_mod( 'colormag_main_header_background', $header_background_default );
		$site_title_typography       = get_theme_mod( 'colormag_site_title_typography', $site_title_typography_default );
		$site_tagline_typography     = get_theme_mod( 'colormag_site_tagline_typography', $site_tagline_typography_default );
		$primary_menu_background     = get_theme_mod( 'colormag_primary_menu_background', $primary_menu_background_default );
		$primary_sub_menu_background = get_theme_mod( 'colormag_primary_sub_menu_background', $primary_sub_menu_background_default );
		$primary_menu_typography     = get_theme_mod( 'colormag_primary_menu_typography', $primary_menu_typography_default );
		$mobile_menu_typography     = get_theme_mod( 'colormag_mobile_menu_typography', $primary_menu_typography_default );
		$primary_sub_menu_typography = get_theme_mod( 'colormag_primary_sub_menu_typography', $primary_sub_menu_typography_default );
		$mobile_sub_menu_typography = get_theme_mod( 'colormag_mobile_sub_menu_typography', $primary_sub_menu_typography_default );
		$post_title_typography       = get_theme_mod( 'colormag_blog_post_title_typography', $post_title_typography_default );
		$single_post_title_typography       = get_theme_mod( 'colormag_single_post_title_typography', $single_post_title_typography_default );

		// Post/Page/Blog options.
		$post_title_color = get_theme_mod( 'colormag_post_title_color', '#333333' );
		$page_title_color = get_theme_mod( 'colormag_page_title_color', '#333333' );
		$blog_post_meta_color  = get_theme_mod( 'colormag_blog_post_meta_color', '#71717A' );
		$search_page_meta_color  = get_theme_mod( 'colormag_search_page_meta_color', '#71717A' );
		$single_post_meta_color  = get_theme_mod( 'colormag_single_post_meta_color', '#71717A' );

		$page_title_typography_default = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '34',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$post_meta_typography_default  = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '12',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);

		$page_title_typography = get_theme_mod( 'colormag_page_title_typography', $page_title_typography_default );
		$blog_post_meta_typography  = get_theme_mod( 'colormag_blog_post_meta_typography', $post_meta_typography_default );
		$single_post_meta_typography  = get_theme_mod( 'colormag_single_post_meta_typography', $post_meta_typography_default );
		$search_page_meta_typography  = get_theme_mod( 'colormag_search_page_meta_typography', $post_meta_typography_default );

		// Footer options.
		$footer_copyright_color                       = get_theme_mod( 'colormag_footer_copyright_text_color', '' );
		$footer_copyright_link_color                  = get_theme_mod( 'colormag_footer_copyright_link_text_color', '#289dcc' );
		$footer_menu_color                            = get_theme_mod( 'colormag_footer_menu_color', '#b1b6b6' );
		$footer_menu_hover_color                      = get_theme_mod( 'colormag_footer_menu_hover_color', '#207daf' );
		$footer_widget_title_color                    = get_theme_mod( 'colormag_footer_widget_title_color', '#ffffff' );
		$footer_widget_content_color                  = get_theme_mod( 'colormag_footer_widget_content_color', '#ffffff' );
		$footer_widget_content_link_text_color        = get_theme_mod( 'colormag_footer_widget_content_link_text_color', '#ffffff' );
		$footer_widget_content_link_text_hover_color  = get_theme_mod( 'colormag_footer_widget_content_link_text_hover_color', '#207daf' );
		$upper_footer_color                           = get_theme_mod( 'colormag_upper_footer_color', '#ffffff' );
		$footer_background_default                    = array(
			'background-color'      => '',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$footer_copyright_background_default          = array(
			'background-color'      => '',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$footer_copyright_typography_default          = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '14',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$footer_menu_typography_default               = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '14',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$footer_sidebar_area_background_default       = array(
			'background-color'      => '',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$footer_upper_sidebar_area_background_default = array(
			'background-color'      => '#2c2e34',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$footer_background                            = get_theme_mod( 'colormag_footer_background', $footer_background_default );
		$footer_copyright_background                  = get_theme_mod( 'colormag_footer_copyright_background', $footer_copyright_background_default );
		$footer_copyright_typography                  = get_theme_mod( 'colormag_footer_copyright_typography', $footer_copyright_typography_default );
		$footer_menu_typography                       = get_theme_mod( 'colormag_footer_menu_typography', $footer_menu_typography_default );
		$footer_sidebar_area_background               = get_theme_mod( 'colormag_footer_sidebar_area_background_setting', $footer_sidebar_area_background_default );
		$footer_upper_sidebar_area_background         = get_theme_mod( 'colormag_footer_upper_sidebar_area_background_setting', $footer_upper_sidebar_area_background_default );

		/**
		 * Color options.
		 */

		$sidebar_widget_title_color = get_theme_mod( 'colormag_sidebar_widget_title_color', '#ffffff' );

		/**
		 * Button.
		 */

		/**
		 * Typography options.
		 */
		$base_typography_default                  = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '15',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.6',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		);
		$headings_typography_default              = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
			'color'          => 'var(--cm-color-6)',
		);
		$heading_h1_typography_default            = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '36',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
			'color'          => 'var(--cm-color-6)',
		);
		$heading_h2_typography_default            = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '32',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
			'color'          => 'var(--cm-color-6)',
		);
		$heading_h3_typography_default            = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '24',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
			'color'          => 'var(--cm-color-6)',
		);
		$heading_h4_typography_default            = array(
			'font-size'   => array(
				'desktop' => array(
					'size' => '24',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height' => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'color'          => 'var(--cm-color-6)',
		);
		$heading_h5_typography_default            = array(
			'font-size'   => array(
				'desktop' => array(
					'size' => '22',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height' => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'color'          => 'var(--cm-color-6)',
		);
		$heading_h6_typography_default            = array(
			'font-size'   => array(
				'desktop' => array(
					'size' => '18',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height' => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'color'          => 'var(--cm-color-6)',
		);
		$content_widget_title_default            = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '18',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.2',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		);
		$widget_title_typography_default          = array(
			'font-family'    => 'inherit',
			'font-weight'    => '500',
			'font-size'      => array(
				'desktop' => array(
					'size' => '18',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.3',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		);
		$comment_title_typography_default         = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '24',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$footer_widget_title_typography_default   = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '18',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$footer_widget_content_typography_default = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '14',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);

		$widget_view_all_button_typography_default = array(
			'font-size' => array(
				'desktop' => array(
					'size' => '',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
		);
		$base_typography                          = get_theme_mod( 'colormag_base_typography', $base_typography_default );
		$headings_typography                      = get_theme_mod( 'colormag_headings_typography', $headings_typography_default );
		$heading_h1_typography                    = get_theme_mod( 'colormag_h1_typography', $heading_h1_typography_default );
		$heading_h2_typography                    = get_theme_mod( 'colormag_h2_typography', $heading_h2_typography_default );
		$heading_h3_typography                    = get_theme_mod( 'colormag_h3_typography', $heading_h3_typography_default );
		$heading_h4_typography                    = get_theme_mod( 'colormag_h4_typography', $heading_h4_typography_default );
		$heading_h5_typography                    = get_theme_mod( 'colormag_h5_typography', $heading_h5_typography_default );
		$heading_h6_typography                    = get_theme_mod( 'colormag_h6_typography', $heading_h6_typography_default );
		$content_widget_title_typography          = get_theme_mod( 'colormag_content_widget_title_typography', $content_widget_title_default );
		$widget_title_typography                  = get_theme_mod( 'colormag_widget_title_typography', $widget_title_typography_default );
		$comment_title_typography                 = get_theme_mod( 'colormag_comment_title_typography', $comment_title_typography_default );
		$footer_widget_title_typography           = get_theme_mod( 'colormag_footer_widget_title_typography', $footer_widget_title_typography_default );
		$footer_widget_content_typography         = get_theme_mod( 'colormag_footer_widget_content_typography', $footer_widget_content_typography_default );
		$widget_view_all_button_typography         = get_theme_mod( 'colormag_widget_view_all_button_typography', $widget_view_all_button_typography_default );

		// Generate dynamic CSS.
		$parse_css = '';

		// For primary color option.
		$primary_color = get_theme_mod( 'colormag_primary_color', '#207daf' );

		$primary_color_css = array(
			'.colormag-button,
			blockquote, button,
			input[type=reset],
			input[type=button],
			input[type=submit],
			.cm-home-icon.front_page_on,
			.cm-post-categories a,
			.cm-primary-nav ul li ul li:hover,
			.cm-primary-nav ul li.current-menu-item,
			.cm-primary-nav ul li.current_page_ancestor,
			.cm-primary-nav ul li.current-menu-ancestor,
			.cm-primary-nav ul li.current_page_item,
			.cm-primary-nav ul li:hover,
			.cm-primary-nav ul li.focus,
			.cm-mobile-nav li a:hover,
			.colormag-header-clean #cm-primary-nav .cm-menu-toggle:hover,
			.cm-header .cm-mobile-nav li:hover,
			.cm-header .cm-mobile-nav li.current-page-ancestor,
			.cm-header .cm-mobile-nav li.current-menu-ancestor,
			.cm-header .cm-mobile-nav li.current-page-item,
			.cm-header .cm-mobile-nav li.current-menu-item,
			.cm-primary-nav ul li.focus > a,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li.focus > a,
			.cm-mobile-nav .current-menu-item>a, .cm-mobile-nav .current_page_item>a,
			.colormag-header-clean .cm-mobile-nav li:hover > a,
			.colormag-header-clean .cm-mobile-nav li.current-page-ancestor > a,
			.colormag-header-clean .cm-mobile-nav li.current-menu-ancestor > a,
			.colormag-header-clean .cm-mobile-nav li.current-page-item > a,
			.colormag-header-clean .cm-mobile-nav li.current-menu-item > a,
			.fa.search-top:hover,
			.widget_call_to_action .btn--primary,
			.colormag-footer--classic .cm-footer-cols .cm-row .cm-widget-title span::before,
			.colormag-footer--classic-bordered .cm-footer-cols .cm-row .cm-widget-title span::before,
			.cm-featured-posts .cm-widget-title span,
			.cm-featured-category-slider-widget .cm-slide-content .cm-entry-header-meta .cm-post-categories a,
			.cm-highlighted-posts .cm-post-content .cm-entry-header-meta .cm-post-categories a,
			.cm-category-slide-next, .cm-category-slide-prev, .slide-next,
			.slide-prev, .cm-tabbed-widget ul li, .cm-posts .wp-pagenavi .current,
			.cm-posts .wp-pagenavi a:hover, .cm-secondary .cm-widget-title span,
			.cm-posts .post .cm-post-content .cm-entry-header-meta .cm-post-categories a,
			.cm-page-header .cm-page-title span, .entry-meta .post-format i,
			.format-link, .cm-entry-button, .infinite-scroll .tg-infinite-scroll,
			.no-more-post-text, .pagination span,
			.cm-footer-cols .cm-row .cm-widget-title span,
			.advertisement_above_footer .cm-widget-title span,
			.error, .cm-primary .cm-widget-title span,
			.related-posts-wrapper.style-three .cm-post-content .cm-entry-title a:hover:before,
			.cm-slider-area .cm-widget-title span,
			.cm-beside-slider-widget .cm-widget-title span,
			.top-full-width-sidebar .cm-widget-title span,
			.wp-block-quote, .wp-block-quote.is-style-large,
			.wp-block-quote.has-text-align-right,
			.page-numbers .current, .search-wrap button,
			.cm-error-404 .cm-btn, .widget .wp-block-heading, .wp-block-search button,
			.widget a::before, .cm-post-date a::before,
			.byline a::before,
			.colormag-footer--classic-bordered .cm-widget-title::before,
			.wp-block-button__link,
			#cm-tertiary .cm-widget-title span,
			.link-pagination .post-page-numbers.current,
			.wp-block-query-pagination-numbers .page-numbers.current,
			.wp-element-button,
			.wp-block-button .wp-block-button__link,
			.wp-element-button,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li:hover,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li.current-menu-ancestor,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li.current-menu-item,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li.focus,
			.cm-primary-nav .cm-random-post a:hover,
			.cm-primary-nav .cm-home-icon a:hover,
			.tg-infinite-pagination .tg-load-more,
			.comment .comment-author-link .post-author,
			.cm-footer-builder .cm-widget-title span,
			.wp-block-search .wp-element-button:hover' => array(
	'background-color' => esc_html( $primary_color ),
),

			'a,
			.cm-layout-2 #cm-primary-nav .fa.search-top:hover,
			.cm-layout-2 #cm-primary-nav.cm-mobile-nav .cm-random-post a:hover .fa-random,
			.cm-layout-2 #cm-primary-nav.cm-primary-nav .cm-random-post a:hover .fa-random,
			.cm-layout-2 .breaking-news .newsticker a:hover,
			.cm-layout-2 .cm-primary-nav ul li.current-menu-item > a,
			.cm-layout-2 .cm-primary-nav ul li.current_page_item > a,
			.cm-layout-2 .cm-primary-nav ul li:hover > a,
			.cm-layout-2 .cm-primary-nav ul li.focus > a
			.dark-skin .cm-layout-2-style-1 #cm-primary-nav.cm-primary-nav .cm-home-icon:hover .fa,
			.byline a:hover, .comments a:hover, .cm-edit-link a:hover, .cm-post-date a:hover,
			.social-links:not(.cm-header-actions .social-links) i.fa:hover, .cm-tag-links a:hover,
			.colormag-header-clean .social-links li:hover i.fa, .cm-layout-2-style-1 .social-links li:hover i.fa,
			.colormag-header-clean .breaking-news .newsticker a:hover, .widget_featured_posts .article-content .cm-entry-title a:hover,
			.widget_featured_slider .slide-content .cm-below-entry-meta .byline a:hover,
			.widget_featured_slider .slide-content .cm-below-entry-meta .comments a:hover,
			.widget_featured_slider .slide-content .cm-below-entry-meta .cm-post-date a:hover,
			.widget_featured_slider .slide-content .cm-entry-title a:hover,
			.widget_block_picture_news.widget_featured_posts .article-content .cm-entry-title a:hover,
			.widget_highlighted_posts .article-content .cm-below-entry-meta .byline a:hover,
			.widget_highlighted_posts .article-content .cm-below-entry-meta .comments a:hover,
			.widget_highlighted_posts .article-content .cm-below-entry-meta .cm-post-date a:hover,
			.widget_highlighted_posts .article-content .cm-entry-title a:hover, i.fa-arrow-up, i.fa-arrow-down,
			.cm-site-title a, #content .post .article-content .cm-entry-title a:hover, .entry-meta .byline i,
			.entry-meta .cat-links i, .entry-meta a, .post .cm-entry-title a:hover, .search .cm-entry-title a:hover,
			.entry-meta .comments-link a:hover, .entry-meta .cm-edit-link a:hover, .entry-meta .cm-post-date a:hover,
			.entry-meta .cm-tag-links a:hover, .single #content .tags a:hover, .count, .next a:hover, .previous a:hover,
			.related-posts-main-title .fa, .single-related-posts .article-content .cm-entry-title a:hover,
			.pagination a span:hover,
			#content .comments-area a.comment-cm-edit-link:hover, #content .comments-area a.comment-permalink:hover,
			#content .comments-area article header cite a:hover, .comments-area .comment-author-link a:hover,
			.comment .comment-reply-link:hover,
			.nav-next a, .nav-previous a,
			#cm-footer .cm-footer-menu ul li a:hover,
			.cm-footer-cols .cm-row a:hover, a#scroll-up i, .related-posts-wrapper-flyout .cm-entry-title a:hover,
			.human-diff-time .human-diff-time-display:hover,
			.cm-layout-2-style-1 #cm-primary-nav .fa:hover,
			.cm-footer-bar a,
			.cm-post-date a:hover,
			.cm-author a:hover,
			.cm-comments-link a:hover,
			.cm-tag-links a:hover,
			.cm-edit-link a:hover,
			.cm-footer-bar .copyright a,
			.cm-featured-posts .cm-entry-title a:hover,
            .cm-featured-posts--style-5.cm-featured-posts .cm-post-title-below-image .cm-post .cm-post-content .cm-entry-title a:hover,
			.cm-posts .post .cm-post-content .cm-entry-title a:hover,
			.cm-posts .post .single-title-above .cm-entry-title a:hover,
			.cm-layout-2 .cm-primary-nav ul li:hover > a,
			.cm-layout-2 #cm-primary-nav .fa:hover,
			.cm-entry-title a:hover,
			button:hover, input[type="button"]:hover,
			input[type="reset"]:hover,
			input[type="submit"]:hover,
			.wp-block-button .wp-block-button__link:hover,
			.cm-button:hover,
			.wp-element-button:hover,
			li.product .added_to_cart:hover,
			.comments-area .comment-permalink:hover'   => array(
			'color' => esc_html( $primary_color ),
			),

			'#cm-primary-nav,
			.cm-contained .cm-header-2 .cm-row, .cm-header-builder.cm-full-width .cm-main-header .cm-header-bottom-row'        => array(
		'border-top-color' => esc_html( $primary_color ),
		),

			'.cm-layout-2 #cm-primary-nav,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li:hover,
			.cm-layout-2 .cm-primary-nav ul > li:hover > a,
			.cm-layout-2 .cm-primary-nav ul > li.current-menu-item > a,
			.cm-layout-2 .cm-primary-nav ul > li.current-menu-ancestor > a,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li.current-menu-ancestor,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li.current-menu-item,
			.cm-layout-2 .cm-primary-nav ul ul.sub-menu li.focus,
			cm-layout-2 .cm-primary-nav ul ul.sub-menu li.current-menu-ancestor,
			cm-layout-2 .cm-primary-nav ul ul.sub-menu li.current-menu-item,
			cm-layout-2 #cm-primary-nav .cm-menu-toggle:hover,
			cm-layout-2 #cm-primary-nav.cm-mobile-nav .cm-menu-toggle,
			cm-layout-2 .cm-primary-nav ul > li:hover > a,
			cm-layout-2 .cm-primary-nav ul > li.current-menu-item > a,
			cm-layout-2 .cm-primary-nav ul > li.current-menu-ancestor > a,
			.cm-layout-2 .cm-primary-nav ul li.focus > a, .pagination a span:hover,
			.cm-error-404 .cm-btn,
			.single-post .cm-post-categories a::after,
			.widget .block-title,
			.cm-layout-2 .cm-primary-nav ul li.focus > a,
			button,
			input[type="button"],
			input[type="reset"],
			input[type="submit"],
			.wp-block-button .wp-block-button__link,
			.cm-button,
			.wp-element-button,
			li.product .added_to_cart'                 => array(
		'border-color' => esc_html( $primary_color ),
		),

			'.cm-secondary .cm-widget-title,
			#cm-tertiary .cm-widget-title,
			.widget_featured_posts .widget-title,
			#secondary .widget-title,
			#cm-tertiary .widget-title,
			.cm-page-header .cm-page-title,
			.cm-footer-cols .cm-row .widget-title,
			.advertisement_above_footer .widget-title,
			#primary .widget-title,
			.widget_slider_area .widget-title,
			.widget_beside_slider .widget-title,
			.top-full-width-sidebar .widget-title,
			.cm-footer-cols .cm-row .cm-widget-title,
			.cm-footer-bar .copyright a,
			.cm-layout-2.cm-layout-2-style-2 #cm-primary-nav,
			.cm-layout-2 .cm-primary-nav ul > li:hover > a,
			.cm-footer-builder .cm-widget-title,
			.cm-layout-2 .cm-primary-nav ul > li.current-menu-item > a' => array(
			'border-bottom-color' => esc_html( $primary_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $primary_color, $primary_color_css );

		$container_width_default = array(
			'size' => 1140,
			'unit' => 'px',
		);

		$container_width = get_theme_mod( 'colormag_container_width', $container_width_default );

		$parse_css .= colormag_parse_slider_css(
			$container_width_default,
			$container_width,
			'.inner-wrap, .cm-container',
			'max-width'
		);

		// Primary color for Elementor.
		if ( defined( 'ELEMENTOR_VERSION' ) ) {

			$primary_color_elementor_css = array(
				'.elementor .elementor-widget-wrap .tg-module-wrapper .module-title span,
				.elementor .elementor-widget-wrap .tg-module-wrapper .tg-post-category,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-5 .tg_module_block .read-more, .elementor .elementor-widget-wrap .tg-module-wrapper tg-module-block.tg-module-block--style-10 .tg_module_block.tg_module_block--list-small:before' => array(
			'background-color' => esc_html( $primary_color ),
			),

				'.elementor .elementor-widget-wrap .tg-module-wrapper .tg-module-meta .tg-module-comments a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper .tg-module-meta .tg-post-auther-name a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper .tg-module-meta .tg-post-date a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper .tg-module-title:hover a,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-7 .tg_module_block--white .tg-module-comments a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-7 .tg_module_block--white .tg-post-auther-name a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-7 .tg_module_block--white .tg-post-date a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-grid .tg_module_grid .tg-module-info .tg-module-meta a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-7 .tg_module_block--white .tg-module-title a:hover,
				.elementor .elementor-widget-wrap .tg-trending-news .trending-news-wrapper a:hover,
				.elementor .elementor-widget-wrap .tg-trending-news .swiper-controls .swiper-button-next:hover, .elementor .elementor-widget-wrap .tg-trending-news .swiper-controls .swiper-button-prev:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-10 .tg_module_block--white .tg-module-title a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-10 .tg_module_block--white .tg-post-auther-name a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-10 .tg_module_block--white .tg-post-date a:hover,
				.elementor .elementor-widget-wrap .tg-module-wrapper.tg-module-block.tg-module-block--style-10 .tg_module_block--white .tg-module-comments a:hover' => array(
			'color' => esc_html( $primary_color ),
			),

				'.elementor .elementor-widget-wrap .tg-trending-news .swiper-controls .swiper-button-next:hover,
				.elementor .elementor-widget-wrap .tg-trending-news .swiper-controls .swiper-button-prev:hover' => array(
			'border-color' => esc_html( $primary_color ),
			),
			);

			$parse_css .= colormag_parse_css( '#207daf', $primary_color, $primary_color_elementor_css );

		}

		/**
		 * Link options.
		 */
		// Link color.
		$link_color = get_theme_mod( 'colormag_link_color', 'var(--cm-color-1)' );

		$link_color_css = array(
			'.cm-entry-summary a,
			.mzb-featured-categories .mzb-post-title a,
			.mzb-tab-post .mzb-post-title a,
			.mzb-post-list .mzb-post-title a,
			.mzb-featured-posts .mzb-post-title a,
			.mzb-featured-categories .mzb-post-title a' => array(
		'color' => esc_html( $link_color ),
		),
		);

		$parse_css .= colormag_parse_css( 'var(--cm-color-1)', $link_color, $link_color_css );

		// Link hover color.
		$link_hover_color = get_theme_mod( 'colormag_link_hover_color', 'var(--cm-color-1)' );

		$link_hover_color_css = array(
			'.post .cm-entry-summary a:hover,
			.mzb-featured-categories .mzb-post-title a:hover,
			.mzb-tab-post .mzb-post-title a:hover,
			.mzb-post-list .mzb-post-title a:hover,
			.mzb-featured-posts .mzb-post-title a:hover,
			.mzb-featured-categories .mzb-post-title a:hover' => array(
		'color' => esc_html( $link_hover_color ),
		),
		);

		$parse_css .= colormag_parse_css( 'var(--cm-color-1)', $link_hover_color, $link_hover_color_css );

		/**
		 * Top bar options.
		 */
		// Top bar border bottom color.
		$top_bar_border_bottom_color = get_theme_mod( 'colormag_top_bar_border_bottom_color', '' );

		$top_bar_border_bottom_color_css = array(
			'.cm-top-bar' => array(
				'border-bottom-color' => esc_html( $top_bar_border_bottom_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $top_bar_border_bottom_color, $top_bar_border_bottom_color_css );

		$top_bar_border_bottom_size_default = array(
			'size' => '',
			'unit' => 'px',
		);

		$top_bar_border_bottom_size = get_theme_mod( 'colormag_top_bar_border_bottom_size', '' );

		$parse_css .= colormag_parse_slider_css(
			$top_bar_border_bottom_size_default,
			$top_bar_border_bottom_size,
			'.cm-top-bar',
			'border-bottom-width'
		);

		// Top bar background color.
		$top_bar_background_color_css = array(
			'.cm-top-bar' => array(
				'background-color' => esc_html( $top_bar_background_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#fff', $top_bar_background_color, $top_bar_background_color_css );

		// Top bar border text color.
		$top_bar_text_color_css = array(
			'.cm-top-bar,
			.date-in-header' => array(
		'color' => esc_html( $top_bar_text_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#555', $top_bar_text_color, $top_bar_text_color_css );

		// Top bar border link color.
		$top_bar_link_color_css = array(
			'.cm-top-bar a' => array(
				'color' => esc_html( $top_bar_link_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $top_bar_link_color, $top_bar_link_color_css );

		// Top bar link hover color.
		$top_bar_link_hover_color_css = array(
			'.cm-top-bar a:hover' => array(
				'color' => esc_html( $top_bar_link_hover_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $top_bar_link_hover_color, $top_bar_link_hover_color_css );

		// Top bar border label color.
		$top_bar_label_color_css = array(
			'.breaking-news-latest' => array(
				'color' => esc_html( $top_bar_label_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#555', $top_bar_label_color, $top_bar_label_color_css );

		//Top bar breaking news label background color.
		$breaking_news_label_background_color_css = array(
			'.breaking-news-latest' => array(
				'background-color' => esc_html( $breaking_news_label_background_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#55ac55', $breaking_news_label_background_color, $breaking_news_label_background_color_css );

		//Top bar breaking news background.
		$breaking_news_background_color_css = array(
			'.cm-top-bar .breaking-news' => array(
				'background-color' => esc_html( $breaking_news_background_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#000', $breaking_news_background_color, $breaking_news_background_color_css );

		$parse_css .= colormag_parse_typography_css(
			$breaking_news_content_typography_default,
			$breaking_news_content_typography,
			'.breaking-news ul li a',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		$parse_css .= colormag_parse_typography_css(
			$breaking_news_label_typography_default,
			$breaking_news_label_typography,
			'.breaking-news .breaking-news-latest',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		/**
		 * Header options.
		 */
		// Background.
		$parse_css .= colormag_parse_background_css( $header_background_default, $header_background, '.cm-header, .dark-skin .cm-main-header' );

		$site_title_color = get_theme_mod( 'colormag_site_title_color', '#207daf' );

		// Site title color.
		$site_title_color_css = array(
			'.cm-site-title a' => array(
				'color' => esc_html( $site_title_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $site_title_color, $site_title_color_css );

		$site_title_hover_color = get_theme_mod( 'colormag_site_title_hover_color', '#207daf' );

		// Site title hover color.
		$site_title_hover_color_css = array(
			'.cm-site-title a:hover' => array(
				'color' => esc_html( $site_title_hover_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $site_title_hover_color, $site_title_hover_color_css );

		// Site tagline color.
		$site_tagline_color = get_theme_mod( 'colormag_site_tagline_color', '#52525B' );

		$site_tagline_color_css = array(
			'.cm-site-description' => array(
				'color' => esc_html( $site_tagline_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#52525B', $site_tagline_color, $site_tagline_color_css );

		/**
		 * Sidebar width.
		 */
		$sidebar_width_default = array(
			'size' => 30,
			'unit' => '%',
		);
		$default_sidebar_layout = get_theme_mod('colormag_default_sidebar_layout', 'right-sidebar' );
		$page_sidebar_layout = get_theme_mod('colormag_page_sidebar_layout', 'right-sidebar' );
		$post_sidebar_layout = get_theme_mod('colormag_post_sidebar_layout', 'right-sidebar');

		if ( 'two_sidebars' === $default_sidebar_layout || 'two-sidebars' === $page_sidebar_layout || 'two-sidebars' === $post_sidebar_layout ) {

			$left_sidebar_width_default = array(
				'size' => 27.19,
				'unit' => '%',
			);

			$left_sidebar_width = get_theme_mod( 'colormag_left_sidebar_width',  $left_sidebar_width_default);

			$right_sidebar_width_default = array(
				'size' => 27.19,
				'unit' => '%',
			);

			$right_sidebar_width = get_theme_mod( 'colormag_sidebar_width', $right_sidebar_width_default );

			$content_width_css = array(
				'.cm-two-sidebars .cm-primary' => array(
					'width' => ( 100 - (float) $right_sidebar_width['size'] - $left_sidebar_width['size'] ) . '%',
				),
			);

			$parse_css .= '@media screen and (min-width: 992px) {';
			$parse_css .= colormag_parse_css( 70, ( 100 - (float) $right_sidebar_width['size'] - $left_sidebar_width['size'] ), $content_width_css );
			$parse_css .= colormag_parse_slider_css(
				$right_sidebar_width_default,
				$right_sidebar_width,
				'.cm-two-sidebars .cm-secondary',
				'width'
			);
			$parse_css .= colormag_parse_slider_css(
				$left_sidebar_width_default,
				$left_sidebar_width,
				'.cm-two-sidebars .cm-content #cm-tertiary',
				'width'
			);
			$parse_css .= '}';

		}

		$sidebar_width = get_theme_mod( 'colormag_sidebar_width', $sidebar_width_default );

		$content_width_css = array(
			'.cm-primary' => array(
				'width' => ( 100 - (float) $sidebar_width['size'] ) . '%',
			),
		);

		$parse_css .= '@media screen and (min-width: 992px) {';
		$parse_css .= colormag_parse_css( 70, ( 100 - (float) $sidebar_width['size'] ), $content_width_css );
		$parse_css .= colormag_parse_slider_css(
			$sidebar_width_default,
			$sidebar_width,
			'.cm-secondary ',
			'width'
		);
		$parse_css .= '}';

		// Site title typography.
		$parse_css .= colormag_parse_typography_css(
			$site_title_typography_default,
			$site_title_typography,
			'.cm-site-title',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Site tagline typography.
		$parse_css .= colormag_parse_typography_css(
			$site_tagline_typography_default,
			$site_tagline_typography,
			'.cm-site-description',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		$site_logo_height = get_theme_mod( 'colormag_site_logo_height' );

		$site_logo_height_default = array(
			'size' => '',
			'unit' => 'px',
		);

		$parse_css .= colormag_parse_slider_css(
			$site_logo_height_default,
			$site_logo_height,
			'.cm-site-branding img',
			'height'
		);

		// Main Header
		$main_header_dimension_padding_default = array(
			'top'    => '',
			'right'  => '',
			'bottom' => '',
			'left'   => '',
			'unit'   => 'px',
		);

		$main_header_dimension_padding = get_theme_mod( 'colormag_primary_menu_padding', $main_header_dimension_padding_default );

		$parse_css .= colormag_parse_dimension_css(
			$main_header_dimension_padding_default,
			$main_header_dimension_padding,
			'.cm-primary-nav',
			'padding'
		);

		// Primary menu text color.
		$primary_menu_text_color_css = array(
			'.cm-primary-nav a,
			.cm-primary-nav ul li ul li a,
			.cm-primary-nav ul li.current-menu-item ul li a,
			.cm-primary-nav ul li ul li.current-menu-item a,
			.cm-primary-nav ul li.current_page_ancestor ul li a,
			.cm-primary-nav ul li.current-menu-ancestor ul li a,
			.cm-primary-nav ul li.current_page_item ul li a,
			.cm-primary-nav li.menu-item-has-children>a::after,
			.cm-primary-nav li.page_item_has_children>a::after,
			.cm-layout-2-style-1 .cm-primary-nav a,
			.cm-layout-2-style-1 .cm-primary-nav ul > li > a' => array(
		'color' => esc_html( $primary_menu_text_color ),
		),
		);

		$parse_css .= colormag_parse_css( '', $primary_menu_text_color, $primary_menu_text_color_css );

		// Primary menu text color.
		$primary_menu_selected_hovered_text_color_css = array(
			'.cm-primary-nav a:hover,
			.cm-primary-nav ul li.current-menu-item a,
			.cm-primary-nav ul li ul li.current-menu-item a,
			.cm-primary-nav ul li.current_page_ancestor a,
			.cm-primary-nav ul li.current-menu-ancestor a,
			.cm-primary-nav ul li.current_page_item a, .cm-primary-nav ul li:hover>a,
			.cm-primary-nav ul li ul li a:hover, .cm-primary-nav ul li ul li:hover>a,
			.cm-primary-nav ul li.current-menu-item ul li a:hover,
			.cm-primary-nav li.page_item_has_children.current-menu-item>a::after,
			.cm-layout-2-style-1 .cm-primary-nav ul li:hover > a' => array(
		'color' => esc_html( $primary_menu_selected_hovered_text_color ),
		),
		);

		$parse_css .= colormag_parse_css( '', $primary_menu_selected_hovered_text_color, $primary_menu_selected_hovered_text_color_css );

		// Primary menu background.
		$parse_css .= colormag_parse_background_css( $primary_menu_background_default, $primary_menu_background, '#cm-primary-nav, .colormag-header-clean #cm-primary-nav .cm-row, .colormag-header-clean--full-width #cm-primary-nav, .cm-header .cm-main-header .cm-primary-nav .cm-row, .cm-home-icon.front_page_on' );

		// Primary sub menu background.
		$parse_css .= colormag_parse_background_css( $primary_sub_menu_background_default, $primary_sub_menu_background, '.cm-primary-nav .sub-menu, .cm-primary-nav .children' );

		$mobile_sub_menu_background_default = array(
			'background-color'      => '#232323',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$mobile_sub_menu_background         = get_theme_mod( 'colormag_mobile_sub_menu_background', $mobile_sub_menu_background_default );
		$parse_css                          .= colormag_parse_background_css( $mobile_sub_menu_background_default, $mobile_sub_menu_background, '.cm-mobile-nav .sub-menu,.cm-mobile-nav .sub-menu li, .cm-mobile-nav .children' );


		// Primary menu border top color.
		$primary_menu_top_border_color_css = array(
			'#cm-primary-nav,
			.colormag-header-clean #cm-primary-nav .cm-row,
			.cm-layout-2-style-1 #cm-primary-nav,
			.colormag-header-clean.colormag-header-clean--top #cm-primary-nav .cm-row,
			.colormag-header-clean--full-width #cm-primary-nav,
			.cm-layout-2-style-1.cm-layout-2-style-1--top #cm-primary-nav,
			.cm-layout-2.cm-layout-2-style-2 #cm-primary-nav' => array(
		'border-top-color' => esc_html( $primary_menu_top_border_color ),
		),

			'.cm-layout-2.cm-layout-2-style-2 #cm-primary-nav' => array(
				'border-bottom-color' => esc_html( $primary_menu_top_border_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $primary_menu_top_border_color, $primary_menu_top_border_color_css );

		// Primary menu typography.
		$parse_css .= colormag_parse_typography_css(
			$primary_menu_typography_default,
			$primary_menu_typography,
			'.cm-primary-nav ul li a',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Mobile menu typography.
		$parse_css .= colormag_parse_typography_css(
			$primary_menu_typography_default,
			$mobile_menu_typography,
			'.cm-mobile-nav ul li a',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Primary sub menu typography.
		$parse_css .= colormag_parse_typography_css(
			$primary_sub_menu_typography_default,
			$primary_sub_menu_typography,
			'.cm-primary-nav ul li ul li a',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Mobile menu typography.
		$parse_css .= colormag_parse_typography_css(
			$primary_sub_menu_typography_default,
			$mobile_sub_menu_typography,
			'.cm-mobile-nav ul li ul li a',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Post title typography.
		$parse_css .= colormag_parse_typography_css(
			$post_title_typography_default,
			$post_title_typography,
			'.cm-entry-title',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Single post title typography.
		$parse_css .= colormag_parse_typography_css(
			$single_post_title_typography_default,
			$single_post_title_typography,
			'.single .cm-entry-header .cm-entry-title',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Primary menu logo height.
		$primary_menu_logo_height = get_theme_mod( 'colormag_primary_menu_logo_height' );

		$primary_menu_logo_height_default = array(
			'size' => '',
			'unit' => 'px',
		);

		$parse_css .= colormag_parse_slider_css(
			$primary_menu_logo_height_default,
			$primary_menu_logo_height,
			'.menu-logo img',
			'height'
		);

		// Primary menu logo spacing.
		$primary_menu_logo_spacing = get_theme_mod( 'colormag_primary_menu_logo_spacing' );

		$primary_menu_logo_spacing_default = array(
			'size' => '',
			'unit' => 'px',
		);

		$parse_css .= colormag_parse_slider_css(
			$primary_menu_logo_spacing_default,
			$primary_menu_logo_spacing,
			'.menu-logo a',
			'margin-right'
		);

		// Header action color option
		$header_action_icon_color     = get_theme_mod( 'colormag_header_action_icon_color', '#fff' );
		$header_action_icon_color_css = array(
			'.fa.search-top'                      => array(
				'color' => esc_html( $header_action_icon_color ),
			),

			'.cm-primary-nav .cm-random-post a svg,
			.cm-mobile-nav .cm-random-post a svg' => array(
		'fill' => esc_html( $header_action_icon_color ),
		),
		);
		$parse_css .= colormag_parse_css( '#fff', $header_action_icon_color, $header_action_icon_color_css );

		// Mobile menu toggle color.
		$mobile_menu_toggle_color = get_theme_mod( 'colormag_mobile_menu_toggle_icon_color', '#fff' );

		$mobile_menu_toggle_color_css = array(
			'.cm-header .cm-menu-toggle svg,
			.cm-header .cm-menu-toggle svg' => array(
		'fill' => esc_html( $mobile_menu_toggle_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#333333', $mobile_menu_toggle_color, $mobile_menu_toggle_color_css );

		$mobile_menu_text_color     = get_theme_mod( 'colormag_mobile_menu_text_color', '' );
		$mobile_menu_text_color_css = array(
			'.cm-mobile-nav a,
		.cm-mobile-nav ul li ul li a,
		.cm-mobile-nav ul li.current-menu-item ul li a,
		.cm-mobile-nav ul li ul li.current-menu-item a,
		.cm-mobile-nav ul li.current_page_ancestor ul li a,
		.cm-mobile-nav ul li.current-menu-ancestor ul li a,
		.cm-mobile-nav ul li.current_page_item ul li a,
		.cm-mobile-nav li.menu-item-has-children>a::after,
		.cm-mobile-nav li.page_item_has_children>a::after,
		.cm-layout-2-style-1 .cm-mobile-nav a,
		.cm-layout-2-style-1 .cm-mobile-nav ul > li > a' => array(
				'color' => esc_html( $mobile_menu_text_color ),
			),
			'.cm-layout-2 .cm-mobile-nav .cm-submenu-toggle .cm-icon,
		.cm-mobile-nav .cm-submenu-toggle .cm-icon'      => array(
				'fill' => esc_html( $mobile_menu_text_color ),
			),
		);
		$parse_css                  .= colormag_parse_css( '', $mobile_menu_text_color, $mobile_menu_text_color_css );

		$mobile_menu_selected_hovered_text_color     = get_theme_mod( 'colormag_mobile_menu_selected_hovered_text_color', '' );
		$mobile_menu_selected_hovered_text_color_css = array(
			'.cm-mobile-nav a:hover,
		.cm-mobile-nav ul li.current-menu-item a,
		.cm-mobile-nav ul li ul li.current-menu-item a,
		.cm-mobile-nav ul li.current_page_ancestor a,
		.cm-mobile-nav ul li.current-menu-ancestor a,
		.cm-mobile-nav ul li.current_page_item a, .cm-mobile-nav ul li:hover>a,
		.cm-mobile-nav ul li ul li a:hover, .cm-mobile-nav ul li ul li:hover>a,
		.cm-mobile-nav ul li.current-menu-item ul li a:hover,
		.cm-mobile-nav li.page_item_has_children.current-menu-item>a::after,
		.cm-layout-2-style-1 .cm-mobile-nav ul li:hover > a' => array(
				'color' => esc_html( $mobile_menu_selected_hovered_text_color ),
			),
			'.cm-layout-2 .cm-mobile-nav li:hover > .cm-submenu-toggle .cm-icon,
			.cm-mobile-nav li:hover > .cm-submenu-toggle .cm-icon
		' => array(
				'fill' => esc_html( $mobile_menu_selected_hovered_text_color ),
			),
		);
		$parse_css                                   .= colormag_parse_css( '', $mobile_menu_selected_hovered_text_color, $mobile_menu_selected_hovered_text_color_css );

		$header_action_icon_hover_color     = get_theme_mod( 'colormag_header_action_icon_hover_color', '' );
		$header_action_icon_hover_color_css = array(
			'.fa.search-top:hover'                        => array(
				'color' => esc_html( $header_action_icon_hover_color ),
			),

			'.cm-primary-nav .cm-random-post a:hover > svg,
			.cm-mobile-nav .cm-random-post a:hover > svg' => array(
		'fill' => esc_html( $header_action_icon_hover_color ),
		),
		);
		$parse_css .= colormag_parse_css( '#fff', $header_action_icon_hover_color, $header_action_icon_hover_color_css );

		/**
		 * Post/Page/Blog options.
		 */
		// Post title color.
		$post_title_color_css = array(
			'.post .cm-entry-title,
			.cm-posts .post .cm-post-content .cm-entry-title a,
			.cm-posts .post .single-title-above .cm-entry-title a' => array(
		'color' => esc_html( $post_title_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#333333', $post_title_color, $post_title_color_css );

		// Post title typography.
		$parse_css .= colormag_parse_typography_css(
			$post_title_typography_default,
			$post_title_typography,
			'.post .cm-entry-header .cm-entry-title,
			.cm-posts .post .cm-post-content .cm-entry-title a,
			.cm-posts .post .single-title-above .cm-entry-title a',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Page title color.
		$page_title_color_css = array(
			'.type-page .cm-entry-title,
			.type-page .cm-entry-title a' => array(
		'color' => esc_html( $page_title_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#333333', $page_title_color, $page_title_color_css );

		// Page title typography.
		$parse_css .= colormag_parse_typography_css(
			$page_title_typography_default,
			$page_title_typography,
			'.type-page .cm-entry-title',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Blog Post meta typography.
		$parse_css .= colormag_parse_typography_css(
			$post_meta_typography_default,
			$blog_post_meta_typography,
			 '.blog .cm-posts .post .cm-post-content .human-diff-time .human-diff-time-display,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-date a,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-author,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-author a,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views a,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-tag-links a,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-comments-link a,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-edit-link a,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-edit-link i,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-reading-time,
			.blog .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-reading-time::before',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Search Page meta typography.
		$parse_css .= colormag_parse_typography_css(
			$post_meta_typography_default,
			$search_page_meta_typography,
			'.search .cm-posts .post .cm-post-content .human-diff-time .human-diff-time-display,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-date a,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-author,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-author a,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views a,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-tag-links a,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-comments-link a,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-edit-link a,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-edit-link i,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-reading-time,
			.search .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-reading-time::before',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Single Post meta typography.
		$parse_css .= colormag_parse_typography_css(
			$post_meta_typography_default,
			$single_post_meta_typography,
			'.single-post .cm-posts .post .cm-post-content .human-diff-time .human-diff-time-display,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-date a,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-author,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-author a,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views a,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-tag-links a,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-comments-link a,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-edit-link a,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-edit-link i,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-reading-time,
			.single-post .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-reading-time::before',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);


		// Blog Post meta color.
		$blog_post_meta_color_css = array(
			'.blog .cm-post-date a,
			.blog .human-diff-time .human-diff-time-display,
			.blog .cm-total-views,
			.blog .cm-author a,
			.blog .cm-post-views,
			.blog .total-views,
			.blog .cm-edit-link a,
			.blog .cm-comments-link a,
			.blog .cm-reading-time,
			.blog.dark-skin .cm-post-date a,
			.blog.dark-skin .cm-author a,
			.blog.dark-skin .cm-comments-link a,
			.blog.dark-skin .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views span,
			.blog .cm-footer-cols .cm-reading-time' => array(
		'color' => esc_html( $blog_post_meta_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#888888', $blog_post_meta_color, $blog_post_meta_color_css );

		// Search Post meta color.
		$search_page_meta_color_css = array(
			'.search .cm-post-date a,
			.search .human-diff-time .human-diff-time-display,
			.search .cm-total-views,
			.search .cm-author a,
			.search .cm-post-views,
			.search .total-views,
			.search .cm-edit-link a,
			.search .cm-comments-link a,
			.search .cm-reading-time,
			.search.dark-skin .cm-post-date a,
			.search.dark-skin .cm-author a,
			.search.dark-skin .cm-comments-link a,
			.search.dark-skin .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views span,
			.search .cm-footer-cols .cm-reading-time' => array(
				'color' => esc_html( $search_page_meta_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#888888', $search_page_meta_color, $search_page_meta_color_css );

		// Single Post meta color.
		$single_post_meta_color_css = array(
			'.single-post .cm-post-date a,
			.single-post .human-diff-time .human-diff-time-display,
			.single-post .cm-total-views,
			.single-post .cm-author a,
			.single-post .cm-post-views,
			.single-post .total-views,
			.single-post .cm-edit-link a,
			.single-post .cm-comments-link a,
			.single-post .cm-reading-time,
			.single-post.dark-skin .cm-post-date a,
			.single-post.dark-skin .cm-author a,
			.single-post.dark-skin .cm-comments-link a,
			.single-post.dark-skin .cm-posts .post .cm-post-content .cm-below-entry-meta .cm-post-views span,
			.single-post .cm-footer-cols .cm-reading-time' => array(
				'color' => esc_html( $single_post_meta_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#888888', $single_post_meta_color, $single_post_meta_color_css );

		$button_typography_default = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '12',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		);

		$button_typography = get_theme_mod( 'colormag_button_typography', $button_typography_default );

		// Button meta typography.
		$parse_css .= colormag_parse_typography_css(
			$button_typography_default,
			$button_typography,
			'.colormag-button,
			input[type="reset"],
			input[type="button"],
			input[type="submit"],
			button,
			.cm-entry-button span,
			.wp-block-button .wp-block-button__link',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Post content background.
		$post_content_background_default = array(
			'background-color'      => '#ffffff',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);

		$post_content_background = get_theme_mod( 'colormag_inside_container_background', $post_content_background_default );

		$parse_css .= colormag_parse_background_css( $post_content_background_default, $post_content_background, '.cm-content' );

		// Post content background.
		$outside_container_default = array(
			'background-color'      => '#ffffff',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);

		$outside_container = get_theme_mod( 'colormag_outside_container_background', $outside_container_default );

		$parse_css .= colormag_parse_background_css( $outside_container_default, $outside_container, 'body' );

		/**
		 * Primary menu top border width.
		 */
		$primary_menu_width_default = array(
			'size' => '4',
			'unit' => 'px',
		);

		$primary_menu_width = get_theme_mod( 'colormag_primary_menu_top_border_width', $primary_menu_width_default );

		$parse_css .= colormag_parse_slider_css(
			$primary_menu_width_default,
			$primary_menu_width,
			'#cm-primary-nav',
			'border-top-width'
		);

		// Button text color.
		$button_text_color = get_theme_mod( 'colormag_button_color', '#ffffff' );

		$button_text_color_css = array(
			'.colormag-button,
			input[type="reset"],
			input[type="button"],
			input[type="submit"],
			button,
			.cm-entry-button span,
			.wp-block-button .wp-block-button__link' => array(
		'color' => esc_html( $button_text_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#ffffff', $button_text_color, $button_text_color_css );

		// Button text hover color.
		$button_hover_text_color = get_theme_mod( 'colormag_button_hover_color', '' );

		$button_hover_text_color_css = array(
			'.colormag-button:hover,
			input[type="reset"]:hover,
			input[type="button"]:hover,
			input[type="submit"]:hover,
			button:hover,
			.cm-entry-button span:hover,
			.wp-block-button .wp-block-button__link:hover' => array(
		'color' => esc_html( $button_hover_text_color ),
		),
		);

		$parse_css .= colormag_parse_css( '', $button_hover_text_color, $button_hover_text_color_css );

		// Button background color.
		$button_background_color = get_theme_mod( 'colormag_button_background_color', 'var(--cm-color-1)' );

		$button_background_color_css = array(
			'.colormag-button,
			input[type="reset"],
			input[type="button"],
			input[type="submit"],
			button,
			.cm-entry-button,
			.wp-block-button .wp-block-button__link' => array(
		'background-color' => esc_html( $button_background_color ),
		),
		);

		$parse_css .= colormag_parse_css( 'var(--cm-color-1)', $button_background_color, $button_background_color_css );

		// Button background hover color.
		$button_background_hover_color = get_theme_mod( 'colormag_button_background_hover_color', '' );

		$button_background_hover_color_css = array(
			'.colormag-button:hover,
			input[type="reset"]:hover,
			input[type="button"]:hover,
			input[type="submit"]:hover,
			button:hover,
			.cm-entry-button span:hover,
			.wp-block-button .wp-block-button__link:hover' => array(
		'background-color' => esc_html( $button_background_hover_color ),
		),
		);

		$parse_css .= colormag_parse_css( '', $button_background_hover_color, $button_background_hover_color_css );

		/**
		 * Footer options.
		 */
		// Background.
		$parse_css .= colormag_parse_background_css( $footer_background_default, $footer_background, '#cm-footer, #cm-footer .cm-footer-cols' );

		// Footer copyright background.
		$parse_css .= colormag_parse_background_css( $footer_copyright_background_default, $footer_copyright_background, '#cm-footer .cm-footer-bar' );

		// Footer copyright color.
		$footer_copyright_color_css = array(
			'.cm-footer-bar-area .cm-footer-bar__2' => array(
				'color' => esc_html( $footer_copyright_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#F4F4F5', $footer_copyright_color, $footer_copyright_color_css );

		// Footer copyright link color.
		$footer_copyright_link_color_css = array(
			'.cm-footer-bar-area .cm-footer-bar__2 a' => array(
				'color' => esc_html( $footer_copyright_link_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#289dcc', $footer_copyright_link_color, $footer_copyright_link_color_css );

		// Footer menu color.
		$footer_menu_color_css = array(
			'.cm-footer-bar-area .cm-footer-bar__1 ul li a' => array(
				'color' => esc_html( $footer_menu_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#b1b6b6', $footer_menu_color, $footer_menu_color_css );

		$footer_upper_background_default = array(
			'background-color'      => '',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$footer_upper_background         = get_theme_mod( 'colormag_upper_footer_background', $footer_upper_background_default );
		$parse_css                      .= colormag_parse_background_css( $footer_upper_background_default, $footer_upper_background, '.cm-footer .cm-upper-footer-cols .widget' );

		// Footer menu hover color.
		$footer_menu_hover_color_css = array(
			'#cm-footer .cm-footer-menu ul li a:hover' => array(
				'color' => esc_html( $footer_menu_hover_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $footer_menu_hover_color, $footer_menu_hover_color_css );

		// Footer copyright typography.
		$parse_css .= colormag_parse_typography_css(
			$footer_copyright_typography_default,
			$footer_copyright_typography,
			'.cm-footer-bar-area .cm-footer-bar__2,
			.cm-footer-bar-area .cm-footer-bar__2 p',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Footer menu typography.
		$parse_css .= colormag_parse_typography_css(
			$footer_menu_typography_default,
			$footer_menu_typography,
			'.cm-footer-bar-area .cm-footer-bar__1 a',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Footer sidebar area background.
		$parse_css .= colormag_parse_background_css( $footer_sidebar_area_background_default, $footer_sidebar_area_background, '.cm-footer-cols' );

		// Footer upper sidebar area background.
		$parse_css .= colormag_parse_background_css( $footer_upper_sidebar_area_background_default, $footer_upper_sidebar_area_background, '#cm-footer .cm-upper-footer-cols .widget' );

		/**
		 * Color options.
		 */
		$base_color = get_theme_mod( 'colormag_base_color', '#444444' );

		// Base color.
		$base_color_css = array(
			'body,
			button,
			input,
			select,
			textarea' => array(
		'color' => esc_html( $base_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#444444', $base_color, $base_color_css );

		// Headings color.
		$headings_color = get_theme_mod( 'colormag_headings_color', '#333333' );

		$headings_color_css = array(
			'h1,
			h2,
			h3,
			h4,
			h5,
			h6,
			.dark-skin h1,
			.dark-skin h2,
			.dark-skin h3,
			.dark-skin h4,
			.dark-skin h5,
			.dark-skin h6' => array(
		'color' => esc_html( $headings_color ),
		),
		);

//		$parse_css .= colormag_parse_css( '#333333', $headings_color, $headings_color_css );

		// Heading H1 color.
		$heading_h1_color = get_theme_mod( 'colormag_h1_color', '#333333' );

		$heading_h1_color_css = array(
			'h1,
			.dark-skin h1' => array(
		'color' => esc_html( $heading_h1_color ),
		),
		);

//		$parse_css .= colormag_parse_css( '#333333', $heading_h1_color, $heading_h1_color_css );

		// Heading H2 color.
		$heading_h2_color = get_theme_mod( 'colormag_h2_color', '#333333' );

		$heading_h2_color_css = array(
			'h2,
			.dark-skin h2' => array(
		'color' => esc_html( $heading_h2_color ),
		),
		);

//		$parse_css .= colormag_parse_css( '#333333', $heading_h2_color, $heading_h2_color_css );

		// Heading H3 color.
		$heading_h3_color = get_theme_mod( 'colormag_h3_color', '#333333' );

		$heading_h3_color_css = array(
			'h3,
			.dark-skin h3' => array(
		'color' => esc_html( $heading_h3_color ),
		),
		);

//		$parse_css .= colormag_parse_css( '#333333', $heading_h3_color, $heading_h3_color_css );

		// Sidebar widget title color.
		$sidebar_widget_title_color_css = array(
			'.cm-secondary .cm-widget-title span,
			.cm-secondary .wp-block-heading,
			#cm-tertiary .cm-widget-title span,
			#cm-tertiary .wp-block-heading' => array(
		'color' => esc_html( $sidebar_widget_title_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#ffffff', $sidebar_widget_title_color, $sidebar_widget_title_color_css );

		// Upper Footer content title color.
		$upper_footer_color_css = array(
			'.cm-footer .cm-upper-footer-cols .cm-entry-title a' => array(
				'color' => esc_html( $upper_footer_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#ffffff', $upper_footer_color, $upper_footer_color_css );

		// Footer widget title color.
		$footer_widget_title_color_css = array(
			'.cm-footer-cols .cm-row .cm-widget-title span' => array(
				'color' => esc_html( $footer_widget_title_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#ffffff', $footer_widget_title_color, $footer_widget_title_color_css );

		// Footer widget content color.
		$footer_widget_content_color_css = array(
			'.cm-footer-cols .cm-row,
			.cm-footer-cols .cm-row p' => array(
		'color' => esc_html( $footer_widget_content_color ),
		),
		);

		$parse_css .= colormag_parse_css( '#ffffff', $footer_widget_content_color, $footer_widget_content_color_css );

		// Footer widget content link text color.
		$footer_widget_content_link_text_color_css = array(
			'.cm-footer-cols .cm-row a' => array(
				'color' => esc_html( $footer_widget_content_link_text_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#ffffff', $footer_widget_content_link_text_color, $footer_widget_content_link_text_color_css );

		// Footer widget content link text hover color.
		$footer_widget_content_link_text_hover_color_css = array(
			'.cm-footer-cols .cm-row a:hover' => array(
				'color' => esc_html( $footer_widget_content_link_text_hover_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $footer_widget_content_link_text_hover_color, $footer_widget_content_link_text_hover_color_css );

		/**
		 * Button.
		 */
		$button_padding_default = array(
			'top'    => '',
			'right'  => '',
			'bottom' => '',
			'left'   => '',
			'unit'   => 'px',
		);

		$button_padding = get_theme_mod( 'colormag_button_dimension_padding', $button_padding_default );

		$parse_css .= colormag_parse_dimension_css(
			$button_padding_default,
			$button_padding,
			'.colormag-button,
			input[type="reset"],
			input[type="button"],
			input[type="submit"],
			button,
			.cm-entry-button,
			.wp-block-button .wp-block-button__link',
			'padding'
		);

		$content_area_padding_default = array(
			'top'    => '60',
			'right'  => '',
			'bottom' => '60',
			'left'   => '',
			'unit'   => 'px',
		);

		$content_area_padding = get_theme_mod( 'colormag_content_area_padding', $content_area_padding_default );

		$parse_css .= colormag_parse_dimension_css(
			$content_area_padding_default,
			$content_area_padding,
			'.cm-content',
			'padding'
		);

		$button_border_radius_default = array(
			'size' => 3,
			'unit' => 'px',
		);

		$button_border_radius = get_theme_mod( 'colormag_button_border_radius', 3 );

		$parse_css .= colormag_parse_slider_css(
			$button_border_radius_default,
			$button_border_radius,
			'.colormag-button, input[type="reset"], input[type="button"], input[type="submit"], button, .more-link, .wp-block-button .wp-block-button__link',
			'border-radius'
		);

		$button_border_width_default = array(
			'size' => '',
			'unit' => 'px',
		);

		$button_border_width = get_theme_mod( 'colormag_button_border_width', '' );

		$parse_css .= colormag_parse_slider_css(
			$button_border_width_default,
			$button_border_width,
			'.colormag-button,
			input[type="reset"],
			input[type="button"],
			input[type="submit"],
			button,
			.cm-entry-button,
			.wp-block-button .wp-block-button__link',
			'border-width'
		);

		$button_border_color = get_theme_mod( 'colormag_button_border_color', '' );

		$parse_css .= colormag_parse_border_css(
			'',
			$button_border_color,
			'.colormag-button,
			input[type="reset"],
			input[type="button"],
			input[type="submit"],
			button,
			.cm-entry-button,
			.wp-block-button .wp-block-button__link',
			'color'
		);

		$button_border_hover_color = get_theme_mod( 'colormag_button_border_hover_color', '' );

		$parse_css .= colormag_parse_border_css(
			'',
			$button_border_hover_color,
			'.colormag-button:hover,
			input[type="reset"]:hover,
			input[type="button"]:hover,
			input[type="submit"]:hover,
			button:hover,
			.cm-entry-button:hover,
			.wp-block-button .wp-block-button__link:hover',
			'color'
		);

		$button_border_style = get_theme_mod( 'colormag_button_border_style', 'none' );

		$parse_css .= colormag_parse_border_css(
			'none',
			$button_border_style,
			'.colormag-button,
			input[type="reset"],
			input[type="button"],
			input[type="submit"],
			button,
			.cm-entry-button,
			.wp-block-button .wp-block-button__link',
			'style'
		);

		/**
		 * Typography.
		 */
		// Base typography.
		$parse_css .= colormag_parse_typography_css(
			$base_typography_default,
			$base_typography,
			'body,
			button,
			input,
			select,
			textarea,
			blockquote p,
			.entry-meta,
			.cm-entry-button,
			dl,
			.previous a,
			.next a,
			.nav-previous a,
			.nav-next a,
			#respond h3#reply-title #cancel-comment-reply-link,
			#respond form input[type="text"],
			#respond form textarea,
			.cm-secondary .widget,
			.cm-error-404 .widget,
			.cm-entry-summary p',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Headings typography.
		$parse_css .= colormag_parse_typography_color_css(
			$headings_typography_default,
			$headings_typography,
			'h1 ,h2, h3, h4, h5, h6',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Heading H1 typography.
		$parse_css .= colormag_parse_typography_color_css(
			$heading_h1_typography_default,
			$heading_h1_typography,
			'h1',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Heading H2 typography.
		$parse_css .= colormag_parse_typography_color_css(
			$heading_h2_typography_default,
			$heading_h2_typography,
			'h2',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Heading H3 typography.
		$parse_css .= colormag_parse_typography_color_css(
			$heading_h3_typography_default,
			$heading_h3_typography,
			'h3',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Heading H4 typography.
		$parse_css .= colormag_parse_typography_color_css(
			$heading_h4_typography_default,
			$heading_h4_typography,
			'h4',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Heading H5 typography.
		$parse_css .= colormag_parse_typography_color_css(
			$heading_h5_typography_default,
			$heading_h5_typography,
			'h5',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Heading H6 typography.
		$parse_css .= colormag_parse_typography_color_css(
			$heading_h6_typography_default,
			$heading_h6_typography,
			'h6',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Content widget typography.
		$parse_css .= colormag_parse_typography_css(
			$content_widget_title_default,
			$content_widget_title_typography,
			'.cm-primary .cm-featured-posts .cm-widget-title',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Widget title typography.
		$parse_css .= colormag_parse_typography_css(
			$widget_title_typography_default,
			$widget_title_typography,
			'.cm-secondary .cm-widget-title span,
			.cm-secondary .wp-block-heading,
			#cm-tertiary .cm-widget-title span,
			#cm-tertiary .wp-block-heading',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Comment title typography.
		$parse_css .= colormag_parse_typography_css(
			$comment_title_typography_default,
			$comment_title_typography,
			'.comments-area .comments-title,
			.comment-reply-title,
			#respond h3#reply-title',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Footer widget title typography.
		$parse_css .= colormag_parse_typography_css(
			$footer_widget_title_typography_default,
			$footer_widget_title_typography,
			'.cm-footer-cols .cm-row .cm-widget-title span',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Footer widget content typography.
		$parse_css .= colormag_parse_typography_css(
			$footer_widget_content_typography_default,
			$footer_widget_content_typography,
			'#cm-footer,
			#cm-footer p,
			#cm-footer .cm-lower-footer-cols',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Scroll to top options.
		$scroll_to_top_normal_background_color     = get_theme_mod( 'colormag_scroll_to_top_background', '' );
		$scroll_to_top_normal_background_color_css = array(
			'#scroll-up i.fa' => array(
				'background-color' => esc_html( $scroll_to_top_normal_background_color ),
			),
		);
		$parse_css                                .= colormag_parse_css( '#16181a', $scroll_to_top_normal_background_color, $scroll_to_top_normal_background_color_css );

		$scroll_to_top_hover_background_color     = get_theme_mod( 'colormag_scroll_to_top_hover_background', '' );
		$scroll_to_top_hover_background_color_css = array(
			'#scroll-up i.fa:hover' => array(
				'background-color' => esc_html( $scroll_to_top_hover_background_color ),
			),
		);
		$parse_css                               .= colormag_parse_css( '', $scroll_to_top_hover_background_color, $scroll_to_top_hover_background_color_css );

		$scroll_to_top_normal_color     = get_theme_mod( 'colormag_scroll_to_top_icon_color', '' );
		$scroll_to_top_normal_color_css = array(
			'a#scroll-up i:before' => array(
				'color' => esc_html( $scroll_to_top_normal_color ),
			),
		);
		$parse_css                     .= colormag_parse_css( '', $scroll_to_top_normal_color, $scroll_to_top_normal_color_css );

		$scroll_to_top_hover_color     = get_theme_mod( 'colormag_scroll_to_top_icon_hover_color', '' );
		$scroll_to_top_hover_color_css = array(
			'a#scroll-up:hover > i:before' => array(
				'color' => esc_html( $scroll_to_top_hover_color ),
			),
		);
		$parse_css                    .= colormag_parse_css( '', $scroll_to_top_hover_color, $scroll_to_top_hover_color_css );

		// Widget view all button color.
		$widget_view_all_button_color = get_theme_mod( 'colormag_widget_view_all_button_color', '' );
		$widget_view_all_button_color_css = array(
			'.cm-view-all-link' => array(
				'color' => esc_html( $widget_view_all_button_color ),
			),
		);
		$parse_css                    .= colormag_parse_css( '', $widget_view_all_button_color, $widget_view_all_button_color_css );

		// Widget view all button bg color.
		$widget_view_all_button_bg = get_theme_mod( 'colormag_widget_view_all_button_background', '' );
		$widget_view_all_button_bg_css = array(
			'.cm-view-all-link' => array(
				'background' => esc_html( $widget_view_all_button_bg ),
			),
		);
		$parse_css                    .= colormag_parse_css( '', $widget_view_all_button_bg, $widget_view_all_button_bg_css );

		// Footer widget content typography.
		$parse_css .= colormag_parse_typography_css(
			$widget_view_all_button_typography_default,
			$widget_view_all_button_typography,
			'.cm-view-all-link',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);


		// Post meta separator.
		$post_meta_separator_color = get_theme_mod( 'colormag_blog_post_meta_separator_color', '' );
		$post_meta_separator_color_css = array(
			'.cm-below-entry-meta.cm-separator span:after' => array(
				'background' => esc_html( $post_meta_separator_color ),
			),
		);
		$post_meta_separator_border_color_css = array(
			'.cm-below-entry-meta.cm-separator span:after' => array(
				'border-color' => esc_html( $post_meta_separator_color ),
			),
		);
		$parse_css                    .= colormag_parse_css( '', $post_meta_separator_color, $post_meta_separator_color_css );
		$parse_css                    .= colormag_parse_css( '', $post_meta_separator_color, $post_meta_separator_border_color_css );

		// Number pagination alignment.
		$number_pagination_alignment = get_theme_mod( 'colormag_pagination_number_alignment', 'flex-start' );
		$number_pagination_alignment_css = array(
			'.nav-links .page-numbers' => array(
				'justify-content' => esc_html( $number_pagination_alignment ),
			),
		);
		$parse_css                    .= colormag_parse_css( '', $number_pagination_alignment, $number_pagination_alignment_css );

		// Form Element color.
		$font_element_text_color = get_theme_mod( 'colormag_form_element_text_color', '' );

		$font_element_text_color_css = array(
			'input, textarea' => array(
				'color' => esc_html( $font_element_text_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $font_element_text_color, $font_element_text_color_css );

		// Form Element hover color.
		$button_hover_text_color = get_theme_mod( 'colormag_form_element_text_focus_color', '' );

		$button_hover_text_color_css = array(
			'input:focus, textarea:focus' => array(
				'color' => esc_html( $button_hover_text_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $button_hover_text_color, $button_hover_text_color_css );

		// Form Element bg color.
		$font_element_text_color = get_theme_mod( 'colormag_form_element_background_color', '' );

		$font_element_text_color_css = array(
			'input, textarea' => array(
				'background-color' => esc_html( $font_element_text_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $font_element_text_color, $font_element_text_color_css );

		// Form Element focus bg color.
		$form_element_hover_text_color = get_theme_mod( 'colormag_form_element_background_focus_color', '' );

		$form_element_hover_text_color_css = array(
			'input:focus, textarea:focus' => array(
				'background-color' => esc_html( $form_element_hover_text_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $form_element_hover_text_color, $form_element_hover_text_color_css );

		$form_element_typography_default = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		);

		$form_element_typography = get_theme_mod( 'colormag_form_element_typography', $form_element_typography_default );

		// Form element typography.
		$parse_css .= colormag_parse_typography_css(
			$form_element_typography_default,
			$form_element_typography,
			'input, textarea, #respond form textarea',
			array(
				'tablet' => 768,
				'mobile' => 600,
			)
		);

		// Form Element focus bg color.
		$form_element_border_style = get_theme_mod( 'colormag_form_element_border_style', '' );

		$form_element_border_style_css = array(
			'input, textarea, #respond form textarea' => array(
				'border-style' => esc_html( $form_element_border_style ),
			),
		);

		$parse_css .= colormag_parse_css( '', $form_element_border_style, $form_element_border_style_css );

		// Form border width.
		$form_element_border_width_default = array(
			'size' => '',
			'unit' => 'px',
		);

		$form_element_border_width = get_theme_mod( 'colormag_form_element_border_width', '' );

		$parse_css .= colormag_parse_slider_css(
			$form_element_border_width_default,
			$form_element_border_width,
			'input, textarea, #respond form textarea',
			'border-width'
		);

		// Form Element focus bg color.
		$form_element_border_color = get_theme_mod( 'colormag_form_element_border_color', '' );

		$form_element_border_color_css = array(
			'input, textarea, #respond form textarea, .cm-entry-summary .wc-block-components-form .wc-block-components-text-input input[type=text], .cm-entry-summary .wc-block-components-form .wc-block-components-text-input input[type=email], .cm-entry-summary .wc-block-components-form .wc-block-components-text-input input[type=tel], .cm-entry-summary .wc-blocks-components-select .wc-blocks-components-select__select, .woocommerce-checkout textarea' => array(
				'border-color' => esc_html( $form_element_border_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $form_element_border_color, $form_element_border_color_css );

		// Breadcrumb Separator color.
		$breadcrumb_separator_color = get_theme_mod( 'colormag_breadcrumb_separator_icon_color', '' );

		$breadcrumb_separator_color_css = array(
			'.trail-separator i' => array(
				'color' => esc_html( $breadcrumb_separator_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $breadcrumb_separator_color, $breadcrumb_separator_color_css );

		// Breadcrumb Label color.
		$breadcrumb_label_color = get_theme_mod( 'colormag_breadcrumb_label_color', '' );

		$breadcrumb_label_color_css = array(
			'.breadcrumb-title' => array(
				'color' => esc_html( $breadcrumb_label_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $breadcrumb_label_color, $breadcrumb_label_color_css );

		// Breadcrumb Link color.
		$breadcrumb_link_color = get_theme_mod( 'colormag_breadcrumb_link_color', '' );

		$breadcrumb_link_color_css = array(
			'.trail-items a' => array(
				'color' => esc_html( $breadcrumb_link_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $breadcrumb_link_color, $breadcrumb_link_color_css );

		// Breadcrumb Active color.
		$breadcrumb_active_color = get_theme_mod( 'colormag_breadcrumb_active_color', '' );

		$breadcrumb_active_color_css = array(
			'.trail-items .trail-item span span' => array(
				'color' => esc_html( $breadcrumb_active_color ),
			),
		);

		$parse_css .= colormag_parse_css( '', $breadcrumb_active_color, $breadcrumb_active_color_css );

		// Breadcrumb Typography.
		$breadcrumb_typography_default = array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'letter-spacing' => array(
				'desktop' => array(
					'size' => '',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		 );

		 $breadcrumb_typography = get_theme_mod( 'colormag_breadcrumb_typography', $breadcrumb_typography_default );

		 // Breadcrumb typography.
		 $parse_css .= colormag_parse_typography_css(
		  $breadcrumb_typography_default,
		  $breadcrumb_typography,
		  '.breadcrumb-trail .breadcrumb-title, .breadcrumb-title li a, .breadcrumb-trail li span',
		  array(
		   'tablet'=>768,
		   'mobile'=>600,
		  )
		 );


		$enable_accessibility = get_theme_mod( 'colormag_enable_accessibility', false );

		if ( $enable_accessibility ){

			$global_accessibility_style = get_theme_mod( 'colormag_accessibility_global_style', 'dotted' );
			$global_accessibility_color = get_theme_mod( 'colormag_global_accessibility_color', '' );
			$input_accessibility_style = get_theme_mod( 'colormag_input_accessibility_style', 'dotted' );
			$input_accessibility_color = get_theme_mod( 'colormag_input_accessibility_color', '' );

			$global_accessibility_color_css = array(
				'a, .cm-primary-nav a, .cm-header-builder .cm-site-title a, .cm-post-categories a, .cm-posts .post .cm-post-content .cm-entry-title a, .cm-modified-date, .cm-post-date a,.cm-author a,.cm-secondary a,.cm-footer-builder a, .cm-entry-summary a' => array(
					'outline-color' => esc_html( $global_accessibility_color ),
				),
			);

			$parse_css .= colormag_parse_css( '', $global_accessibility_color, $global_accessibility_color_css );

			$global_accessibility_style_css = array(
				'a, .cm-primary-nav a, .cm-header-builder .cm-site-title a, .cm-post-categories a, .cm-posts .post .cm-post-content .cm-entry-title a, .cm-modified-date,.cm-post-date a, .cm-author a,.cm-secondary a,.cm-footer-builder a, .cm-entry-summary a' => array(
					'outline-style' => esc_html( $global_accessibility_style ),
				),
			);

			$parse_css .= colormag_parse_css( '', $global_accessibility_style, $global_accessibility_style_css );

			$input_accessibility_color_css = array(
				'input:focus, input[type="text"]:focus, input[type="email"]:focus, input[type="url"]:focus, input[type="password"]:focus, input[type="reset"]:focus, input[type="search"]:focus, input[type="number"]:focus, textarea:focus,.wp-block-search .wp-block-search__input:focus, .wp-block-search__input:focus, .woocommerce-ordering select.orderby:focus, #coupon_code:focus, .woocommerce-page #comment:focus, .woocommerce #reviews #respond input#submit:focus, .woocommerce a.add_to_cart_button:focus, .woocommerce .button.single_add_to_cart_button:focus, .woocommerce .woocommerce-cart-form button:focus, .woocommerce .woocommerce-cart-form__cart-item .quantity .qty:focus, .woocommerce .woocommerce-billing-fields .woocommerce-billing-fields__field-wrapper .woocommerce-input-wrapper > .input-text:focus, .woocommerce #order_comments:focus, .woocommerce #place_order:focus, .woocommerce .woocommerce-address-fields .woocommerce-address-fields__field-wrapper .woocommerce-input-wrapper > .input-text:focus, .woocommerce .woocommerce-MyAccount-content form button:focus, .woocommerce .woocommerce-MyAccount-content .woocommerce-EditAccountForm .woocommerce-form-row .woocommerce-Input.input-text:focus, body #content .woocommerce form .form-row .select2-container--default .select2-selection--single:focus, .woocommerce.woocommerce-js .quantity input[type=number]:focus, .woocommerce-js .woocommerce-mini-cart-item .quantity input[type=number]:focus' => array(
					'outline-color' => esc_html( $input_accessibility_color ),
				),
			);

			$parse_css .= colormag_parse_css( '', $input_accessibility_color, $input_accessibility_color_css );

			$input_accessibility_style_css = array(
				'input:focus, input[type="text"]:focus, input[type="email"]:focus, input[type="url"]:focus, input[type="password"]:focus, input[type="reset"]:focus, input[type="search"]:focus, input[type="number"]:focus, textarea:focus,.wp-block-search .wp-block-search__input:focus, .wp-block-search__input:focus, .woocommerce-ordering select.orderby:focus, #coupon_code:focus, .woocommerce-page #comment:focus, .woocommerce #reviews #respond input#submit:focus, .woocommerce a.add_to_cart_button:focus, .woocommerce .button.single_add_to_cart_button:focus, .woocommerce .woocommerce-cart-form button:focus, .woocommerce .woocommerce-cart-form__cart-item .quantity .qty:focus, .woocommerce .woocommerce-billing-fields .woocommerce-billing-fields__field-wrapper .woocommerce-input-wrapper > .input-text:focus, .woocommerce #order_comments:focus, .woocommerce #place_order:focus, .woocommerce .woocommerce-address-fields .woocommerce-address-fields__field-wrapper .woocommerce-input-wrapper > .input-text:focus, .woocommerce .woocommerce-MyAccount-content form button:focus, .woocommerce .woocommerce-MyAccount-content .woocommerce-EditAccountForm .woocommerce-form-row .woocommerce-Input.input-text:focus, body #content .woocommerce form .form-row .select2-container--default .select2-selection--single:focus, .woocommerce.woocommerce-js .quantity input[type=number]:focus, .woocommerce-js .woocommerce-mini-cart-item .quantity input[type=number]:focus' => array(
					'outline-style' => esc_html( $input_accessibility_style ),
				),
			);

			$parse_css .= colormag_parse_css( '', $input_accessibility_style, $input_accessibility_style_css );

			$input_accessibility_width_css = array(
				'input:focus, input[type="text"]:focus, input[type="email"]:focus, input[type="url"]:focus, input[type="password"]:focus, input[type="reset"]:focus, input[type="search"]:focus, input[type="number"]:focus, textarea:focus,.wp-block-search .wp-block-search__input:focus, .wp-block-search__input:focus, .woocommerce-ordering select.orderby:focus, #coupon_code:focus, .woocommerce-page #comment:focus, .woocommerce #reviews #respond input#submit:focus, .woocommerce a.add_to_cart_button:focus, .woocommerce .button.single_add_to_cart_button:focus, .woocommerce .woocommerce-cart-form button:focus, .woocommerce .woocommerce-cart-form__cart-item .quantity .qty:focus, .woocommerce .woocommerce-billing-fields .woocommerce-billing-fields__field-wrapper .woocommerce-input-wrapper > .input-text:focus, .woocommerce #order_comments:focus, .woocommerce #place_order:focus, .woocommerce .woocommerce-address-fields .woocommerce-address-fields__field-wrapper .woocommerce-input-wrapper > .input-text:focus, .woocommerce .woocommerce-MyAccount-content form button:focus, .woocommerce .woocommerce-MyAccount-content .woocommerce-EditAccountForm .woocommerce-form-row .woocommerce-Input.input-text:focus, body #content .woocommerce form .form-row .select2-container--default .select2-selection--single:focus, .woocommerce.woocommerce-js .quantity input[type=number]:focus, .woocommerce-js .woocommerce-mini-cart-item .quantity input[type=number]:focus' => array(
					'outline-width' => 'thin',
				),
			);

			$parse_css .= colormag_parse_css( '','thin', $input_accessibility_width_css );

		}

		// Add the custom CSS rendered dynamically, which is static.
		$parse_css .= self::render_custom_output();
		$parse_css .= ColorMag_Dynamic_Builder_CSS::render_builder_output( $parse_css );

		$parse_css .= $dynamic_css;

		$parse_css .= self::colormag_editor_block_css();
		$parse_css .= self::generate_color_palette_css_variables();

		return apply_filters( 'colormag_theme_dynamic_css', $parse_css );
	}

	/**
	 * Function to output Custom CSS code, which does not have the specific CSS design option, ie, static CSS code.
	 *
	 * @return string
	 */
	public static function render_custom_output() {

		/**
		 * Variable declarations.
		 */
		// Post metas.
		$colormag_all_entry_meta_remove      = get_theme_mod( 'colormag_all_entry_meta_remove', 0 );
		$colormag_author_entry_meta_remove   = get_theme_mod( 'colormag_author_entry_meta_remove', 0 );
		$colormag_date_entry_meta_remove     = get_theme_mod( 'colormag_date_entry_meta_remove', 0 );
		$colormag_category_entry_meta_remove = get_theme_mod( 'colormag_category_entry_meta_remove', 0 );
		$colormag_comments_entry_meta_remove = get_theme_mod( 'colormag_comments_entry_meta_remove', 0 );
		$colormag_tags_entry_meta_remove     = get_theme_mod( 'colormag_tags_entry_meta_remove', 0 );

		// Footer options.
		$footer_background_default = array(
			'background-color'      => '',
			'background-image'      => '',
			'background-position'   => 'center center',
			'background-size'       => 'auto',
			'background-attachment' => 'scroll',
			'background-repeat'     => 'repeat',
		);
		$footer_background         = get_theme_mod( 'colormag_footer_background', $footer_background_default );

		// Color in menu.
		$category_menu_color = get_theme_mod( 'colormag_enable_category_color', '' );

		// Generate dynamic CSS.
		$colormag_custom_css = '';

		/**
		 * Post metas.
		 */
		// Total post meta remove.
		if ( 1 == $colormag_all_entry_meta_remove ) {
			$colormag_custom_css .= '.cm-entry-header-meta, .cm-below-entry-meta, .tg-module-meta, .tg-cm-post-categories{display:none}';
		}

		// Author remove from post meta.
		if ( 1 == $colormag_author_entry_meta_remove ) {
			$colormag_custom_css .= '.cm-below-entry-meta .byline, .elementor .elementor-widget-wrap .tg-module-wrapper .tg-module-meta .tg-post-auther-name{display:none}';
		}

		// Date remove from post meta.
		if ( 1 == $colormag_date_entry_meta_remove ) {
			$colormag_custom_css .= '.cm-below-entry-meta .cm-post-date, .elementor .elementor-widget-wrap .tg-module-wrapper .tg-module-meta .tg-post-date{display:none}';
		}

		// Category remove from post meta.
		if ( 1 == $colormag_category_entry_meta_remove ) {
			$colormag_custom_css .= '.cm-entry-header-meta, .tg-cm-post-categories{display:none}';
		}

		// Comments remove from post meta.
		if ( 1 == $colormag_comments_entry_meta_remove ) {
			$colormag_custom_css .= '.cm-below-entry-meta .comments, .elementor .elementor-widget-wrap .tg-module-wrapper .tg-module-meta .tg-module-comments{display:none}';
		}

		// Tags remove from post meta.
		if ( 1 == $colormag_tags_entry_meta_remove ) {
			$colormag_custom_css .= '.cm-below-entry-meta .cm-tag-links{display:none}';
		}

		/**
		 * Footer options.
		 */

		// Footer background image.
		if ( $footer_background['background-image'] ) {
			$colormag_custom_css .= '.cm-footer-cols, .cm-footer-bar, .colormag-footer--classic .cm-footer-bar{background-color:transparent}';
		}

		// Category color in menu options.
		if ( 1 == $category_menu_color ) {
			$args       = array(
				'orderby'    => 'id',
				'hide_empty' => 0,
			);
			$categories = get_categories( $args );

			$colormag_custom_css .= '.cm-primary-nav .menunav-menu>li.menu-item-object-category>a{position:relative}.cm-primary-nav .menunav-menu>li.menu-item-object-category::before{content:"";position:absolute;top:-4px;left:0;right:0;height:4px;z-index:10;transition:width .35s}>a';

			foreach ( $categories as $category ) {
				$cat_color = get_theme_mod( 'colormag_category_color_' . absint( $category->term_id ) );
				$cat_id    = $category->term_id;

				if ( $cat_color ) {
					$colormag_custom_css .= '.cm-primary-nav .menu-item-object-category.menu-item-category-' . $cat_id . '::before, .cm-primary-nav .menu-item-object-category.menu-item-category-' . $cat_id . ':hover{background:' . $cat_color . '}';
				}
			}
		}

		return $colormag_custom_css;
	}

	/**
	 * Returns the background CSS property for editor.
	 *
	 * @param string|array $default_value Default value.
	 * @param string|array $output_value  Updated value.
	 * @param string       $selector      CSS selector.
	 *
	 * @return string|void Generated CSS for background CSS property.
	 */
	public static function colormag_editor_block_css() {
		$parse_css = '';

		// Primary color.
		$primary_color     = get_theme_mod( 'colormag_primary_color', '#207daf' );
		$primary_color_css = array(
			'.mzb-featured-posts, .mzb-social-icon, .mzb-featured-categories, .mzb-social-icons-insert'
			=> array(
				'--color--light--primary' => ColorMag_Utils::adjust_color_opacity( $primary_color, 10 ),
			),

			'body'
			=> array(
				'--color--light--primary' => esc_html( $primary_color ),
				'--color--primary'        => esc_html( $primary_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#207daf', $primary_color, $primary_color_css );

		// Post meta color.
		$post_meta_color     = get_theme_mod( 'colormag_post_meta_color', '#71717A' );
		$post_meta_color_css = array(
			'body' => array(
				'--color--gray' => esc_html( $post_meta_color ),
			),
		);

		$parse_css .= colormag_parse_css( '#888888', $post_meta_color, $post_meta_color_css );
		return $parse_css;
	}

	/**
	 * Generate CSS variables for ColorMag color palette.
	 *
	 * @return string Generated CSS variables.
	 */
	public static function generate_color_palette_css_variables() {
		$global_palette = get_theme_mod(
			'colormag_color_palette',
			array(
				'id'     => 'preset-5',
				'name'   => 'Default',
				'colors' => array(
					'cm-color-1' => '#257BC1',
					'cm-color-2' => '#2270B0',
					'cm-color-3' => '#FFFFFF',
					'cm-color-4' => '#F9FEFD',
					'cm-color-5' => '#27272A',
					'cm-color-6' => '#16181A',
					'cm-color-7' => '#8F8F8F',
					'cm-color-8' => '#FFFFFF',
					'cm-color-9' => '#C7C7C7',
				),
			)
		);

		if ( empty( $global_palette ) ) {
			$css = ':root{
				--wp--preset--color--cm-color-1: inherit;
				--wp--preset--color--cm-color-2: inherit;
				--wp--preset--color--cm-color-3: inherit;
				--wp--preset--color--cm-color-4: inherit;
				--wp--preset--color--cm-color-5: inherit;
				--wp--preset--color--cm-color-6: inherit;
				--wp--preset--color--cm-color-7: inherit;
				--wp--preset--color--cm-color-8: inherit;
				--wp--preset--color--cm-color-9: inherit;
			}';
		} else {
			$css = ':root {';

			if ( isset( $global_palette['colors'] ) && is_array( $global_palette['colors'] ) ) {
				foreach ( $global_palette['colors'] as $color_key => $color_value ) {
					// Generate WordPress preset color variables
					$css .= '--wp--preset--color--' . $color_key . ':' . $color_value . ';';
				}
			}

			$css .= '}';
		}



		return $css;
	}

		/**
	 * Return dynamic CSS output.
	 *
	 * @param string $dynamic_css Dynamic CSS.
	 * @param string $dynamic_css_filtered Dynamic CSS Filters.
	 *
	 * @return string Generated CSS.
	 */
	public static function render_wc_output( $dynamic_css, $dynamic_css_filtered = '' ) {

		// Generate dynamic CSS.
		$parse_wc_css     = $dynamic_css;
		$wc_primary_color = get_theme_mod( 'colormag_primary_color', '#207daf' );

		$wc_primary_color_css = array(
			'.woocommerce-cart .actions .button,
		li.product .added_to_cart:hover'                   => array(
		'border-color' => esc_html( $wc_primary_color ),
		),

			'li.product .added_to_cart,
		.woocommerce-MyAccount-navigation ul .is-active a' => array(
		'background-color' => esc_html( $wc_primary_color ),
		),

			'.woocommerce-cart .actions .button[aria-disabled="true"]' => array(
				'background-color' => esc_html( $wc_primary_color ),
				'border-color'     => esc_html( $wc_primary_color ),
			),

			'.product-subtotal,
		.woocommerce-cart .actions .button,
		li.product .added_to_cart:hover,
		.stock.in-stock,
		.woocommerce-MyAccount-navigation ul li a:hover,
		.woocommerce-MyAccount-navigation ul li a:focus'   => array(
		'color' => esc_html( $wc_primary_color ),
		),
		);

		$parse_wc_css .= colormag_parse_css( '#207daf', $wc_primary_color, $wc_primary_color_css );

		return $parse_wc_css;
	}
}
